<?php
Yii::import("webroot.themes.press.ThemeFunctions"); 
$epaper_config = ModuleLoader::getConfig("epaper");
$epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];
$edition_models = EpaperFeaturedEdition::model()->with("rEpaperEdition")->findAll(new CDbCriteria(array("order" => "fed_order ASC")));
if(!isset($featured_editions_perrow)){
    $featured_editions_perrow = 3;
}
 
if(count($edition_models)>0) { ?>
        <div class="clearfix feditionlist-block">
            <header class="title-header">
                <h1 class="heading text-center"><?php echo Press_ThemeSettings::i()->text_fedition; ?></h1>
            </header> 
            <?php
            $x = 1;
            foreach ($edition_models as $model) {
                $model = $model->rEpaperEdition;
                if($model->ed_status == "private"){
                    continue;
                }
                $imageurl = $epaper_mediadir . $model->ed_image;
                if (trim($model->ed_image) == "") {
                    $thumb = ImageHelpers::i()->getDefaultImage($featured_editions_thumbsize["width"], $featured_editions_thumbsize["height"], true);
                } else {
                    $thumb = ImageHelpers::i()->getThumbImage($imageurl, $featured_editions_thumbsize["width"], $featured_editions_thumbsize["height"], true);
                }
                if ($x == 1) {
                    echo "<div class='row'>";
                }
                ?>
                <section class="col-md-<?php echo 12/$featured_editions_perrow ?> text-center col-lg-<?php echo 12/$featured_editions_perrow ?> epost">
                    <a class="thumbnail epost-image float" href="<?php echo $this->createUrl("//epaper/default/show", array("id" => $model->ed_id, "alias" => $model->ed_alias)); ?>">
                        <img src="<?php echo $thumb; ?>" />
                    </a>
                    <header class="epost-header">
                        <h1 class="epost-title"><a href="<?php echo $this->createUrl("//epaper/default/show", array("id" => $model->ed_id, "alias" => $model->ed_alias)); ?>"><?php echo CHtml::encode($model->ed_title); ?></a></h1>             
                    </header>
                    <div class="epost-date">
                    <?php echo Helpers::i()->formatDate($model->ed_date,"F j, Y"); ?>
                    </div> 
                    <div class="epost-category">
                        <a href="<?php echo $this->createUrl("//epaper/default/index", array("id" => $model->rCategory->cat_id, "alias" => $model->rCategory->cat_alias)) ?>">[ <?php echo CHtml::encode($model->rCategory->cat_title); ?> ]</a>
                    </div> 
                </section>
            <?php 
            
            if ($x == $featured_editions_perrow) {
                echo "</div>";
                $x = 1;
            } else {
                $x++;
            }
                } ?>
        </div> 
        <?php 
            if ($x != 1) {
                echo "</div>";
            }
        } ?> 